/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.world.gen.feature;

import com.minecraftabnormals.neapolitan.common.block.MintBlock;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class MintPondFeature
extends Feature<NoFeatureConfig> {
    public MintPondFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos pos, NoFeatureConfig config) {
        BlockPos blockpos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, pos);
        List directions = Direction.Plane.HORIZONTAL.func_239636_a_().collect(Collectors.toList());
        boolean spruce = false;
        int i = 0;
        BlockPos.Mutable position = new BlockPos.Mutable();
        ArrayList<Object> waterPositions = new ArrayList<Object>();
        ArrayList<BlockPos> mintPositions = new ArrayList<BlockPos>();
        position.func_239621_a_((Vector3i)blockpos, random.nextInt(8) - random.nextInt(8), random.nextInt(4) - random.nextInt(4), random.nextInt(8) - random.nextInt(8));
        if (MintPondFeature.isSafeSpotForWater(world, (BlockPos)position)) {
            waterPositions.add(position);
            for (Direction direction : directions) {
                BlockPos offsetPos = position.func_177972_a(direction);
                if (!MintPondFeature.isSafeSpotForWater(world, offsetPos)) continue;
                waterPositions.add(offsetPos);
                BlockPos cornerPos = offsetPos.func_177972_a(direction.func_176746_e());
                if (MintPondFeature.isSafeSpotForWater(world, cornerPos) && random.nextInt(3) != 0) {
                    waterPositions.add(cornerPos);
                }
                for (Direction direction2 : directions) {
                    BlockPos offsetPos2 = offsetPos.func_177972_a(direction);
                    if (!MintPondFeature.isSafeSpotForWater(world, offsetPos2) || random.nextInt(3) != 0) continue;
                    waterPositions.add(offsetPos2);
                    BlockPos cornerPos2 = offsetPos2.func_177972_a(direction2.func_176746_e());
                    if (!MintPondFeature.isSafeSpotForWater(world, cornerPos2) || random.nextInt(4) == 0) continue;
                    waterPositions.add(cornerPos);
                }
            }
            for (BlockPos blockPos : waterPositions) {
                for (Direction direction : directions) {
                    mintPositions.add(blockPos.func_177984_a().func_177972_a(direction));
                }
            }
            for (BlockPos blockPos : waterPositions) {
                MintPondFeature.placeWater(world, blockPos);
            }
            for (BlockPos blockPos : mintPositions) {
                if (!spruce && random.nextInt(3) == 0) {
                    Features.field_243866_bL.func_242765_a(world, chunkGenerator, random, blockPos);
                    spruce = true;
                    continue;
                }
                MintPondFeature.placeMint(world, blockPos, random);
            }
            ++i;
        }
        return i > 0;
    }

    private static void placeMint(ISeedReader world, BlockPos pos, Random random) {
        if (world.func_180495_p(pos).func_196958_f() && world.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_196658_i) && random.nextInt(4) == 0) {
            world.func_180501_a(pos, (BlockState)((BlockState)((Block)NeapolitanBlocks.MINT.get()).func_176223_P().func_206870_a((Property)MintBlock.AGE, (Comparable)Integer.valueOf(4))).func_206870_a((Property)MintBlock.SPROUTS, (Comparable)Integer.valueOf(1 + random.nextInt(3))), 2);
        }
    }

    private static void placeWater(ISeedReader world, BlockPos pos) {
        world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 2);
        if (world.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_196658_i) || world.func_180495_p(pos.func_177977_b()).func_196958_f()) {
            world.func_180501_a(pos.func_177977_b(), Blocks.field_150346_d.func_176223_P(), 2);
        }
    }

    private static boolean isSafeSpotForWater(ISeedReader world, BlockPos pos) {
        return world.func_180495_p(pos).func_203425_a(Blocks.field_196658_i) && !world.func_180495_p(pos.func_177976_e()).func_196958_f() && !world.func_180495_p(pos.func_177974_f()).func_196958_f() && !world.func_180495_p(pos.func_177978_c()).func_196958_f() && !world.func_180495_p(pos.func_177968_d()).func_196958_f();
    }
}

